create or replace package googleSitemap as
   /*
   * ARTICLES Sitemaps Package
   *
   * Author: Niall Mc Phillips 
   * Company: Long Acre sàrl
   * 
   * This package provides functionality for generating XML sitemaps for the ARTICLES application.
   * It follows the Sitemaps XML protocol as specified by sitemaps.org and includes Google News extensions.
   *
   * Dependencies:
   * - Requires access to articles data via vw_articles view
   * - Uses APEX utilities for HTTP response generation
   * - Oracle XML functions for sitemap structure generation
   */

   -- Base URL constant for article links construction
   c_base_url constant varchar2(255) := 'https://www.example.com/dyn/r/pressapp/articles/';

   /**
   * Generates the main XML sitemap for public articles.
   * Includes links to individual article pages with last modification dates,
   * change frequency, priority, and Google News extensions.
   *
   * Features:
   * - Dynamic priority and change frequency based on article age
   * - Google News sitemap extensions for enhanced search visibility
   * - UTF-8 encoded XML output with proper namespaces
   * - Direct HTTP response output (application/xml content type)
   *
   * Business Rules:
   * - Recent articles (≤15 days): daily frequency, priority 0.8
   * - Moderately recent (≤90 days): weekly frequency, priority 0.6
   * - Older articles: monthly frequency, priority 0.4
   *
   * @return Outputs XML sitemap directly to HTTP response
   */
   procedure generateMainSitemap;
   
end googleSitemap;